import path from 'path';
import { defineConfig, loadEnv } from 'vite';
import react from '@vitejs/plugin-react';

export default defineConfig(({ mode }) => {
    const env = loadEnv(mode, '.', '');
    return {
      build: {
        outDir: path.resolve(__dirname, '../assets'),
        emptyOutDir: false, // Не удаляем images и другие файлы
        // Очищаем только JS файлы перед сборкой
        rollupOptions: {
          output: {
            entryFileNames: 'index-[hash].js',
            chunkFileNames: 'chunks/[name]-[hash].js',
            assetFileNames: 'static/[name]-[hash][extname]',
          },
        },
      },
      server: {
        port: 5173,
        host: '0.0.0.0',
        hmr: {
          host: '188.130.206.8',
        },
      },
      plugins: [react()],
      define: {
        'process.env.API_KEY': JSON.stringify(env.GEMINI_API_KEY),
        'process.env.GEMINI_API_KEY': JSON.stringify(env.GEMINI_API_KEY)
      },
      resolve: {
        alias: {
          '@': path.resolve(__dirname, '.'),
        }
      }
    };
});
