
import React, { useState } from 'react';

const FeaturedSection: React.FC = () => {
  const [activeSlide, setActiveSlide] = useState(0);
  const slides = 5;

  return (
    <section className="px-4 py-2">
      <h2 className="text-white font-bold text-2xl mb-4">Рекомендуем</h2>
      <div className="relative rounded-2xl overflow-hidden h-48 flex flex-col justify-end p-6 text-white bg-cover bg-center" style={{ backgroundImage: "url('/images/banner.jpg')" }}>
        <div className="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>
        <div className="relative z-10">
            <p className="text-sm font-semibold tracking-widest text-gray-300">ВСТРЕЧАЙТЕ ПРОДЮСЕРА</p>
            <h3 className="text-3xl font-bold mt-1">Первый ИИ-агент для музыки</h3>
        </div>
      </div>
      <div className="flex justify-center mt-4 space-x-2">
        {Array.from({ length: slides }).map((_, index) => (
          <button
            key={index}
            onClick={() => setActiveSlide(index)}
            className={`h-2 w-2 rounded-full transition-colors ${index === activeSlide ? 'bg-white' : 'bg-gray-600'}`}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </section>
  );
};

export default FeaturedSection;
