import React from 'react';
import { HomeIcon, PlusCircleIcon, LibraryIcon, UserIcon } from './Icons';

interface BottomNavProps {
  activeTab: string;
  setActiveTab: (tab: string) => void;
  isAuthenticated: boolean;
  onAuthClick?: () => void;
}

const NavItem: React.FC<{ label: string; icon: React.ReactNode; isActive: boolean; onClick: () => void }> = ({ label, icon, isActive, onClick }) => {
  return (
    <button onClick={onClick} className="flex flex-col items-center justify-center w-full pt-2 pb-1 transition-colors">
      <div className={`transition-colors ${isActive ? 'text-white' : 'text-gray-400 hover:text-white'}`}>
        {icon}
      </div>
      <span className={`text-xs mt-1 transition-colors ${isActive ? 'text-white' : 'text-gray-400'}`}>{label}</span>
    </button>
  );
};

const BottomNav: React.FC<BottomNavProps> = ({
  activeTab,
  setActiveTab,
  isAuthenticated,
  onAuthClick,
}) => {
  const profileLabel = isAuthenticated ? 'Профиль' : 'Вход';

  const navItems = [
    { id: 'home', label: 'Главная', icon: <HomeIcon className="h-6 w-6" /> },
    { id: 'create', label: 'Создать', icon: <PlusCircleIcon className="h-6 w-6" /> },
    { id: 'library', label: 'Библиотека', icon: <LibraryIcon className="h-6 w-6" /> },
    { id: 'more', label: profileLabel, icon: <UserIcon className="h-6 w-6" /> },
  ];

  return (
    <nav className="fixed bottom-0 left-0 right-0 bg-[#1a1b24]/80 backdrop-blur-sm border-t border-gray-700/50">
      <div className="flex justify-around items-center max-w-lg mx-auto">
        {navItems.map((item) => (
          <NavItem
            key={item.id}
            label={item.label}
            icon={item.icon}
            isActive={activeTab === item.id}
            onClick={() => {
              if (item.id === 'more' && !isAuthenticated) {
                onAuthClick?.();
                setActiveTab(item.id);
                return;
              }

              setActiveTab(item.id);
            }}
          />
        ))}
      </div>
    </nav>
  );
};

export default BottomNav;