<?php

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\MusicGenerationController;
use App\Http\Controllers\ConfigController;
use App\Http\Controllers\PublicSongsController;
use App\Http\Controllers\SongsController;
use Illuminate\Support\Facades\Route;

Route::post('auth/register', [AuthController::class, 'register']);
Route::post('auth/login', [AuthController::class, 'login']);
Route::post('auth/telegram', [AuthController::class, 'telegram']);
Route::post('auth/vkid', [AuthController::class, 'vkid']);
Route::post('auth/demo', [AuthController::class, 'demo']);
Route::post('music/callback', [MusicGenerationController::class, 'callback'])->name('music.callback');
Route::get('config/auth', [ConfigController::class, 'auth']);

// Public songs (no auth required)
Route::get('songs/public', [PublicSongsController::class, 'index']);

Route::middleware('auth.api')->group(function () {
    Route::post('auth/logout', [AuthController::class, 'logout']);
    Route::get('auth/me', [AuthController::class, 'me']);
    Route::post('music/generate', [MusicGenerationController::class, 'generate']);
    Route::post('music/extend', [MusicGenerationController::class, 'extend']);
    Route::post('music/cover', [MusicGenerationController::class, 'cover']);
    Route::post('music/add-instrumental', [MusicGenerationController::class, 'addInstrumental']);
    Route::post('music/add-vocals', [MusicGenerationController::class, 'addVocals']);
    Route::get('music/tasks/{task}', [MusicGenerationController::class, 'show']);
    
    // User songs
    Route::get('songs', [SongsController::class, 'index']);
    
    // Song publishing
    Route::post('songs/publish', [PublicSongsController::class, 'publish']);
    Route::post('songs/unpublish', [PublicSongsController::class, 'unpublish']);
});

