<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class DemoUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::updateOrCreate(
            ['email' => 'demo@sunoai.ru'],
            [
                'name' => 'Demo User',
                'password' => Hash::make('demo-password'),
                'is_telegram' => false,
                'token_balance' => 1000,
                'generation_count' => 0,
            ]
        );
    }
}






