<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('songs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->string('suno_song_id')->unique();
            $table->string('task_id')->nullable()->index();
            $table->string('title');
            $table->string('artist')->nullable();
            $table->text('prompt')->nullable();
            $table->text('tags')->nullable();
            $table->string('artwork_url')->nullable();
            $table->string('source_artwork_url')->nullable();
            $table->string('audio_url')->nullable();
            $table->string('source_audio_url')->nullable();
            $table->string('stream_url')->nullable();
            $table->string('source_stream_url')->nullable();
            $table->string('source_audio_id')->nullable();
            $table->string('status')->default('pending');
            $table->string('model')->nullable();
            $table->integer('duration_seconds')->nullable();
            $table->boolean('is_public')->default(false)->index();
            $table->timestamp('published_at')->nullable();
            $table->integer('plays_count')->default(0);
            $table->integer('likes_count')->default(0);
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['is_public', 'published_at']);
            $table->index(['is_public', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('songs');
    }
};
