<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (! Schema::hasColumn('users', 'vkid_user_id')) {
                $table->string('vkid_user_id')
                    ->nullable()
                    ->unique()
                    ->after('telegram_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'vkid_user_id')) {
                $table->dropUnique('users_vkid_user_id_unique');
                $table->dropColumn('vkid_user_id');
            }
        });
    }
};


