<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class InjectSanctumToken
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        $hasAuthorization = $request->headers->has('Authorization')
            || $request->server->has('HTTP_AUTHORIZATION');

        if (! $hasAuthorization) {
            $token = $request->header('X-Auth-Token')
                ?? $request->header('X-Authorization')
                ?? $request->query('token');

            if (is_string($token) && $token !== '') {
                $request->headers->set('Authorization', 'Bearer '.$token);
                $request->server->set('HTTP_AUTHORIZATION', 'Bearer '.$token);
            }
        }

        return $next($request);
    }
}
