<?php

namespace App\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

class ConfigController extends Controller
{
    public function auth(): JsonResponse
    {
        $botToken = Config::get('services.telegram.bot_token');
        $configuredLoginBot = trim((string) Config::get('services.telegram.login_bot'));

        $botId = null;
        if ($botToken && Str::contains($botToken, ':')) {
            $botId = (int) Str::before($botToken, ':');
        }

        $loginBot = $configuredLoginBot !== '' ? $configuredLoginBot : null;

        if (! $loginBot && $botToken) {
            $cacheKey = 'telegram:login_bot_name';
            $loginBot = Cache::remember($cacheKey, now()->addHour(), function () use ($botToken) {
                try {
                    $response = Http::timeout(5)->get("https://api.telegram.org/bot{$botToken}/getMe");

                    if ($response->successful()) {
                        $username = $response->json('result.username');

                        if (is_string($username) && $username !== '') {
                            return '@'.ltrim($username, '@');
                        }
                    }
                } catch (\Throwable) {
                    // ignore HTTP errors
                }

                return null;
            });
        }

        $demoAuthConfig = Config::get('services.demo_auth', []);
        $demoEnabled = (bool) ($demoAuthConfig['enabled'] ?? false);

        return response()->json([
            'telegram_login_bot' => $loginBot,
            'telegram_bot_id' => $botId,
            'demo_enabled' => $demoEnabled,
        ]);
    }
}


