import React from 'react';
import { Song } from '../types';
import { ChevronDownIcon, MoreHorizontalIcon, PlayIcon, PauseIcon, SkipBackIcon, SkipForwardIcon, ShuffleIcon, RepeatIcon } from './Icons';

interface PlayerModalProps {
  song: Song;
  isPlaying: boolean;
  onTogglePlay: () => void;
  onClose: () => void;
}

const PlayerModal: React.FC<PlayerModalProps> = ({ song, isPlaying, onTogglePlay, onClose }) => {
  return (
    <div className="fixed inset-0 bg-gradient-to-b from-[#4a4b5a] to-[#1a1b24] z-50 flex flex-col p-4 animate-slide-up">
      <header className="flex justify-between items-center flex-shrink-0">
        <button onClick={onClose} className="p-2 -ml-2">
          <ChevronDownIcon className="w-7 h-7 text-white" />
        </button>
        <div className="text-center">
            <p className="text-sm text-gray-300">ИГРАЕТ ИЗ ПЛЕЙЛИСТА</p>
            <p className="font-bold text-white">В тренде</p>
        </div>
        <button className="p-2 -mr-2">
          <MoreHorizontalIcon className="w-7 h-7 text-white" />
        </button>
      </header>

      <main className="flex-grow flex flex-col justify-center items-center py-8 min-h-0">
        <img src={song.imageUrl} alt={song.title} className="w-full max-w-xs aspect-square rounded-2xl shadow-2xl" />
        <div className="text-center mt-8 w-full px-4">
            <h2 className="text-3xl font-bold text-white truncate">{song.title}</h2>
            <p className="text-lg text-gray-300 mt-1 truncate">{song.artist}</p>
        </div>
        
        {/* Progress Bar */}
        <div className="w-full mt-8 px-2">
            <div className="h-1.5 bg-gray-600 rounded-full">
                <div className="h-1.5 bg-white rounded-full w-1/4"></div>
            </div>
            <div className="flex justify-between text-xs text-gray-400 mt-1.5">
                <span>0:45</span>
                <span>3:00</span>
            </div>
        </div>
        
        {/* Controls */}
        <div className="flex items-center justify-center space-x-6 mt-6 w-full">
            <button className="text-gray-300 hover:text-white"><ShuffleIcon className="w-7 h-7"/></button>
            <button className="text-white"><SkipBackIcon className="w-10 h-10"/></button>
            <button onClick={onTogglePlay} className="bg-white text-black rounded-full p-5 shadow-lg">
                {isPlaying ? <PauseIcon className="w-10 h-10"/> : <PlayIcon className="w-10 h-10"/>}
            </button>
            <button className="text-white"><SkipForwardIcon className="w-10 h-10"/></button>
            <button className="text-gray-300 hover:text-white"><RepeatIcon className="w-7 h-7"/></button>
        </div>
      </main>
    </div>
  );
};

export default PlayerModal;
